<?php
require __DIR__ . '/../app/bootstrap.php';

use App\Core\Router;
use App\Controllers\AuthController;
use App\Controllers\TournamentController;
use App\Controllers\TeamController;
use App\Controllers\FixtureController;
use App\Controllers\PlayerController;
use App\Controllers\MatchDetailController;
use App\Controllers\StandingsController;
use App\Controllers\PlayoffController;
use App\Controllers\TournamentSetupController;

$router = new Router();

// Rutas públicas
$router->get('home', function() {
    view('auth/welcome', ['title' => 'Bienvenido']);
});
$router->get('login', [AuthController::class, 'showLogin']);
$router->post('login', [AuthController::class, 'login']);
$router->get('logout', [AuthController::class, 'logout']);

// Rutas protegidas (chequeo dentro de cada acción)
$router->get('dashboard', [TournamentController::class, 'dashboard']);

$router->get('tournaments', [TournamentController::class, 'index']);
$router->get('tournaments_create', [TournamentController::class, 'create']);
$router->post('tournaments_store', [TournamentController::class, 'store']);

$router->get('teams', [TeamController::class, 'index']);
$router->get('teams_create', [TeamController::class, 'create']);
$router->post('teams_store', [TeamController::class, 'store']);

$router->get('fixtures', [FixtureController::class, 'index']);
$router->get('standings', [StandingsController::class, 'index']);
$router->get('players', [PlayerController::class, 'index']);
$router->get('match_detail', [MatchDetailController::class, 'show']);
$router->get('playoffs', [PlayoffController::class, 'index']);
$router->get('tournament_setup', [TournamentSetupController::class, 'config']);
$router->post('fixtures_generate', [FixtureController::class, 'generate']);
$router->post('fixtures_result', [FixtureController::class, 'saveResult']);
$router->post('playoffs_generate', [PlayoffController::class, 'generate']);
$router->post('playoffs_save', [PlayoffController::class, 'saveResult']);
$router->post('tournament_save_settings', [TournamentSetupController::class, 'saveSettings']);
$router->post('tournament_add_team', [TournamentSetupController::class, 'addTeam']);
$router->post('tournament_remove_team', [TournamentSetupController::class, 'removeTeam']);
$router->post('players_store', [PlayerController::class, 'store']);
$router->post('players_delete', [PlayerController::class, 'delete']);
$router->post('match_lineup_add', [MatchDetailController::class, 'addLineup']);
$router->post('match_lineup_remove', [MatchDetailController::class, 'removeLineup']);
$router->post('match_event_add', [MatchDetailController::class, 'addEvent']);
$router->post('match_event_delete', [MatchDetailController::class, 'deleteEvent']);

$router->dispatch();
