<?php
// Simple env loader
function env($key, $default = null) {
    static $vars = null;
    if ($vars === null) {
        $vars = [];
        $envPath = __DIR__ . '/../.env';
        if (file_exists($envPath)) {
            foreach (file($envPath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) as $line) {
                if (strpos(trim($line), '#') === 0) continue;
                [$k,$v] = array_map('trim', explode('=', $line, 2));
                $vars[$k] = $v;
            }
        }
    }
    return $vars[$key] ?? $default;
}

return [
    'db' => [
        'host' => env('DB_HOST', 'localhost'),
        'name' => env('DB_NAME', 'futbol_torneos'),
        'user' => env('DB_USER', 'root'),
        'pass' => env('DB_PASS', ''),
        'charset' => 'utf8mb4'
    ],
    'app' => [
        'url' => env('APP_URL', '/'),
        'name' => env('APP_NAME', 'Futbol Pro'),
        'env'  => env('APP_ENV', 'production'),
        'debug'=> env('APP_DEBUG', 'false') === 'true',
    ]
];
