<h3>Configuración de torneo</h3>
<div class="row g-3">
  <div class="col-md-4">
    <div class="card">
      <div class="card-header">Selecciona torneo</div>
      <div class="card-body">
        <form method="get" action="index.php">
          <input type="hidden" name="r" value="tournament_setup">
          <select name="tid" class="form-select" onchange="this.form.submit()">
            <?php foreach ($tournaments as $opt): ?>
              <option value="<?= $opt['id'] ?>" <?= $opt['id']==$tid?'selected':'' ?>>
                <?= htmlspecialchars($opt['name']) ?> (<?= htmlspecialchars($opt['season']) ?>)
              </option>
            <?php endforeach; ?>
          </select>
        </form>
        <?php if ($t): ?>
        <hr>
        <form method="post" action="index.php?r=tournament_save_settings">
          <input type="hidden" name="tournament_id" value="<?= $tid ?>">
          <div class="mb-2">
            <label class="form-label">Etapa objetivo</label>
            <select name="knockout_target" class="form-select">
              <option value="QF" <?= $t['knockout_target']=='QF'?'selected':'' ?>>Cuartos (8 equipos)</option>
              <option value="R16" <?= $t['knockout_target']=='R16'?'selected':'' ?>>Octavos (16 equipos)</option>
            </select>
          </div>
          <div class="row">
            <div class="col-6 mb-2">
              <label class="form-label">Clasificados directos</label>
              <input type="number" name="direct_qualifiers" class="form-control" value="<?= (int)$t['direct_qualifiers'] ?>">
            </div>
            <div class="col-6 mb-2">
              <label class="form-label">Cupos de Play-in</label>
              <input type="number" name="playin_slots" class="form-control" value="<?= (int)$t['playin_slots'] ?>">
            </div>
          </div>
          <div class="form-check mb-2">
            <input class="form-check-input" type="checkbox" name="two_legs" id="twolegs" <?= ((int)$t['two_legs'])?'checked':'' ?> disabled>
            <label class="form-check-label" for="twolegs">Ida/Vuelta (v4)</label>
          </div>
          <button class="btn btn-primary">Guardar</button>
        </form>
        <?php endif; ?>
      </div>
    </div>
  </div>
  <div class="col-md-8">
    <div class="card">
      <div class="card-header">Equipos asignados</div>
      <div class="card-body">
        <?php if (!$t): ?>
          <p class="text-muted">Crea y selecciona un torneo.</p>
        <?php else: ?>
          <form class="row g-2 align-items-end" method="post" action="index.php?r=tournament_add_team">
            <input type="hidden" name="tournament_id" value="<?= $tid ?>">
            <div class="col-md-8">
              <label class="form-label">Agregar equipo</label>
              <select name="team_id" class="form-select">
                <?php foreach ($allTeams as $tt): ?>
                  <option value="<?= $tt['id'] ?>"><?= htmlspecialchars($tt['name']) ?></option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-md-4">
              <button class="btn btn-success w-100">Añadir</button>
            </div>
          </form>
          <hr>
          <table class="table table-sm">
            <thead><tr><th>#</th><th>Equipo</th><th>Acción</th></tr></thead>
            <tbody>
              <?php $i=1; foreach ($assigned as $a): ?>
                <tr>
                  <td><?= $i++ ?></td>
                  <td><?= htmlspecialchars($a['name']) ?></td>
                  <td>
                    <form method="post" action="index.php?r=tournament_remove_team" onsubmit="return confirm('Quitar equipo del torneo?')">
                      <input type="hidden" name="tournament_id" value="<?= $tid ?>">
                      <input type="hidden" name="team_id" value="<?= $a['team_id'] ?>">
                      <button class="btn btn-sm btn-outline-danger">Quitar</button>
                    </form>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>
