<h3>Playoffs</h3>
<form class="mb-3" method="get" action="index.php">
  <input type="hidden" name="r" value="playoffs">
  <div class="row g-2 align-items-end">
    <div class="col-md-6">
      <label class="form-label">Torneo (ID)</label>
      <input type="number" name="tid" class="form-control" value="<?= (int)$tid ?>" placeholder="ID del torneo">
    </div>
    <div class="col-md-2">
      <button class="btn btn-outline-secondary w-100">Cambiar</button>
    </div>
    <div class="col-md-4 text-end">
      <a class="btn btn-outline-primary" href="index.php?r=tournament_setup&tid=<?= (int)$tid ?>">Config torneo</a>
    </div>
  </div>
</form>

<?php if (!empty($tournament)): ?>
<div class="alert alert-info">
  <strong><?= htmlspecialchars($tournament['name']) ?> (<?= htmlspecialchars($tournament['season']) ?>)</strong> · Objetivo: <?= $tournament['knockout_target'] ?> · Directos: <?= (int)$tournament['direct_qualifiers'] ?> · Play-in: <?= (int)$tournament['playin_slots'] ?>
</div>
<?php endif; ?>

<?php if (!empty($error)): ?>
  <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>

<div class="card p-3 mb-3">
  <form method="post" action="index.php?r=playoffs_generate">
    <input type="hidden" name="tournament_id" value="<?= (int)$tid ?>">
    <button class="btn btn-primary">Generar llaves según reglas</button>
    <a class="btn btn-outline-secondary" href="index.php?r=standings&tid=<?= (int)$tid ?>">Ver tabla</a>
  </form>
</div>

<div class="row g-3">
  <div class="col-lg-6">
    <div class="card">
      <div class="card-header bg-secondary text-white">Play-in</div>
      <div class="card-body">
        <?php if (empty($playin)): ?>
          <p class="text-muted">Sin partidos de play-in.</p>
        <?php else: ?>
          <table class="table table-sm">
            <thead><tr><th>#</th><th>Local</th><th></th><th>Visitante</th><th>Guardar</th></tr></thead>
            <tbody>
              <?php foreach ($playin as $m): ?>
              <tr>
                <td><?= $m['id'] ?></td>
                <td><?= htmlspecialchars($m['home_name'] ?? 'TBD') ?></td>
                <td>
                  <form method="post" action="index.php?r=playoffs_save" class="d-flex align-items-center gap-1">
                    <input type="hidden" name="tournament_id" value="<?= (int)$tid ?>">
                    <input type="hidden" name="match_id" value="<?= $m['id'] ?>">
                    <input type="number" name="home_goals" class="form-control form-control-sm" style="width:70px" value="<?= (int)$m['home_goals'] ?>">
                    <span class="mx-1">-</span>
                    <input type="number" name="away_goals" class="form-control form-control-sm" style="width:70px" value="<?= (int)$m['away_goals'] ?>">
                </td>
                <td><?= htmlspecialchars($m['away_name'] ?? 'TBD') ?></td>
                <td><button class="btn btn-sm btn-success">Guardar</button></form></td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        <?php endif; ?>
      </div>
    </div>
  </div>
  <div class="col-lg-6">
    <div class="card">
      <div class="card-header bg-secondary text-white">Ronda Principal</div>
      <div class="card-body">
        <?php if (!empty($r16)): ?>
          <h6>Octavos (R16)</h6>
          <?php $list=$r16; include __DIR__.'/partials_round_table.php'; ?>
        <?php elseif (!empty($qf)): ?>
          <h6>Cuartos (QF)</h6>
          <?php $list=$qf; include __DIR__.'/partials_round_table.php'; ?>
        <?php else: ?>
          <p class="text-muted">Sin llaves principales generadas.</p>
        <?php endif; ?>
      </div>
    </div>
  </div>
  <div class="col-lg-6">
    <div class="card">
      <div class="card-header bg-secondary text-white">Semifinales</div>
      <div class="card-body">
        <?php if (empty($semis)): ?><p class="text-muted">Aún no hay semifinales.</p><?php else: ?>
          <?php $list=$semis; include __DIR__.'/partials_round_table.php'; ?>
        <?php endif; ?>
      </div>
    </div>
  </div>
  <div class="col-lg-6">
    <div class="card">
      <div class="card-header bg-secondary text-white">Final</div>
      <div class="card-body">
        <?php if (empty($final)): ?><p class="text-muted">Aún no hay final.</p><?php else: ?>
          <table class="table table-sm">
            <thead><tr><th>#</th><th>Local</th><th></th><th>Visitante</th><th>Guardar</th></tr></thead>
            <tbody>
              <tr>
                <td><?= $final['id'] ?></td>
                <td><?= htmlspecialchars($final['home_name'] ?? 'TBD') ?></td>
                <td>
                  <form method="post" action="index.php?r=playoffs_save" class="d-flex align-items-center gap-1">
                    <input type="hidden" name="tournament_id" value="<?= (int)$tid ?>">
                    <input type="hidden" name="match_id" value="<?= $final['id'] ?>">
                    <input type="number" name="home_goals" class="form-control form-control-sm" style="width:70px" value="<?= (int)$final['home_goals'] ?>">
                    <span class="mx-1">-</span>
                    <input type="number" name="away_goals" class="form-control form-control-sm" style="width:70px" value="<?= (int)$final['away_goals'] ?>">
                </td>
                <td><?= htmlspecialchars($final['away_name'] ?? 'TBD') ?></td>
                <td><button class="btn btn-sm btn-success">Guardar</button></form></td>
              </tr>
            </tbody>
          </table>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>
