<?php $config = require __DIR__ . '/../../../config/config.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?= htmlspecialchars($config['app']['name']) ?></title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<nav class="navbar navbar-expand-lg bg-dark navbar-dark">
  <div class="container-fluid">
    <a class="navbar-brand" href="index.php?r=dashboard"><?= htmlspecialchars($config['app']['name']) ?></a>
    <div class="collapse navbar-collapse">
      <ul class="navbar-nav me-auto">
        <?php if (auth()): ?>
          <li class="nav-item"><a class="nav-link" href="index.php?r=tournaments">Torneos</a></li>
          <li class="nav-item"><a class="nav-link" href="index.php?r=teams">Equipos</a></li>
          <li class="nav-item"><a class="nav-link" href="index.php?r=fixtures">Fixture</a></li>
        <?php endif; ?>
      <li class="nav-item"><a class="nav-link" href="index.php?r=standings">Tabla</a></li>
          <li class="nav-item"><a class="nav-link" href="index.php?r=playoffs">Playoffs</a></li>
          <li class="nav-item"><a class="nav-link" href="index.php?r=tournament_setup">Config torneo</a></li>
          <li class="nav-item"><a class="nav-link" href="index.php?r=players">Jugadores</a></li>
        </ul>
      <ul class="navbar-nav">
        <?php if (auth()): ?>
          <li class="nav-item"><span class="navbar-text me-3">Hola, <?= htmlspecialchars(auth()['name']) ?></span></li>
          <li class="nav-item"><a class="btn btn-outline-light" href="index.php?r=logout">Salir</a></li>
        <?php else: ?>
          <li class="nav-item"><a class="btn btn-outline-light" href="index.php?r=login">Ingresar</a></li>
        <?php endif; ?>
      </ul>
    </div>
  </div>
</nav>
<div class="container py-4">
