<?php
namespace App\Models;

class Tournament {
    public static function all() {
        $pdo = Database::conn();
        return $pdo->query("SELECT * FROM tournaments ORDER BY created_at DESC")->fetchAll();
    }
    public static function count() {
        $pdo = Database::conn();
        return (int)$pdo->query("SELECT COUNT(*) c FROM tournaments")->fetch()['c'];
    }
    public static function create($name, $season) {
        $pdo = Database::conn();
        $stmt = $pdo->prepare("INSERT INTO tournaments(name, season) VALUES (?,?)");
        $stmt->execute([$name, $season]);
    }
}

public static function allWithSettings() {
    $pdo = Database::conn();
    return $pdo->query("SELECT * FROM tournaments ORDER BY created_at DESC")->fetchAll();
}
public static function find($id) {
    $pdo = Database::conn();
    $stmt = $pdo->prepare("SELECT * FROM tournaments WHERE id=?");
    $stmt->execute([$id]);
    return $stmt->fetch();
}
public static function updateSettings($id, $target, $direct, $playin, $twolegs) {
    $pdo = Database::conn();
    $stmt = $pdo->prepare("UPDATE tournaments SET knockout_target=?, direct_qualifiers=?, playin_slots=?, two_legs=? WHERE id=?");
    $stmt->execute([$target, $direct, $playin, $twolegs, $id]);
}
