<?php
namespace App\Models;

class Suspension {
    public static function isPlayerSuspendedForMatch($player_id, $match_id): bool {
        $pdo = Database::conn();
        $sql = "SELECT COUNT(*) c FROM player_suspensions
                WHERE player_id=? AND match_id=? AND active=1";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$player_id, $match_id]);
        return (int)$stmt->fetch()['c'] > 0;
    }

    public static function listForMatchAndTeam($match_id, $team_id): array {
        $pdo = Database::conn();
        $sql = "SELECT ps.*, p.name
                FROM player_suspensions ps
                JOIN players p ON p.id=ps.player_id
                WHERE ps.match_id=? AND ps.team_id=? AND ps.active=1
                ORDER BY p.name";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$match_id, $team_id]);
        return $stmt->fetchAll();
    }

    public static function onMatchCompleted($match_id) {
        $pdo = Database::conn();
        $sql = "SELECT * FROM player_suspensions WHERE match_id=? AND active=1";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$match_id]);
        $rows = $stmt->fetchAll();
        foreach ($rows as $r) {
            $remaining = max(0, ((int)$r['matches_remaining']) - 1);
            if ($remaining <= 0) {
                $pdo->prepare("UPDATE player_suspensions SET matches_remaining=0, active=0 WHERE id=?")->execute([$r['id']]);
            } else {
                $pdo->prepare("UPDATE player_suspensions SET matches_remaining=? WHERE id=?")->execute([$remaining, $r['id']]);
            }
        }
    }

    public static function evaluateMatch($match_id) {
        $pdo = Database::conn();
        $m = $pdo->prepare("SELECT * FROM matches WHERE id=?");
        $m->execute([$match_id]);
        $match = $m->fetch();
        if (!$match) return;
        $tid = (int)$match['tournament_id'];
        $rules = self::rules($tid);

        $ev = $pdo->prepare("SELECT player_id, team_id, type FROM match_events WHERE match_id=? AND type IN ('yellow','red') AND player_id IS NOT NULL");
        $ev->execute([$match_id]);
        $cards = [];
        foreach ($ev as $e) {
            $pid = (int)$e['player_id'];
            if (!isset($cards[$pid])) $cards[$pid] = ['team_id'=>(int)$e['team_id'],'y'=>0,'r'=>0];
            if ($e['type']==='yellow') $cards[$pid]['y']++;
            if ($e['type']==='red') $cards[$pid]['r']++;
        }

        foreach ($cards as $pid => $info) {
            if ($info['y'] > 0) {
                $ins = $pdo->prepare("INSERT INTO player_card_accum(player_id, team_id, tournament_id, yellows, last_match_id) VALUES (?,?,?,?,?) ON DUPLICATE KEY UPDATE yellows = yellows + VALUES(yellows), last_match_id=VALUES(last_match_id)");
                $ins->execute([$pid, $info['team_id'], $tid, $info['y'], $match_id]);
            }
            $reason = null; $matchesLen = 0;
            if ($info['r'] >= 1) { $reason = 'red'; $matchesLen = max(1, (int)$rules['red_min_matches']); }
            elseif ($info['y'] >= 2) { $reason = 'double_yellow'; $matchesLen = max(1, (int)$rules['double_yellow_matches']); }
            if ($reason) {
                $exists = $pdo->prepare("SELECT COUNT(*) c FROM player_suspensions WHERE player_id=? AND origin_match_id=?");
                $exists->execute([$pid, $match_id]);
                if ((int)$exists->fetch()['c'] == 0) {
                    $next = $pdo->prepare("SELECT id FROM matches
                                           WHERE tournament_id=? AND (home_team_id=? OR away_team_id=?)
                                             AND (home_goals IS NULL OR away_goals IS NULL)
                                             AND id > ?
                                           ORDER BY id ASC LIMIT 1");
                    $next->execute([$tid, $info['team_id'], $info['team_id'], $match_id]);
                    $next_row = $next->fetch();
                    $next_id = $next_row ? (int)$next_row['id'] : null;
                    $insS = $pdo->prepare("INSERT INTO player_suspensions(player_id, team_id, tournament_id, origin_match_id, match_id, matches_remaining, reason, active) VALUES (?,?,?,?,?,?,?,1)");
                    $insS->execute([$pid, $info['team_id'], $tid, $match_id, $next_id, $matchesLen, $reason]);
                }
            }
        }

        $th = (int)$rules['yellow_threshold'];
        if ($th > 0) {
            $stmt = $pdo->prepare("SELECT pca.*, p.team_id FROM player_card_accum pca JOIN players p ON p.id=pca.player_id WHERE pca.tournament_id=?");
            $stmt->execute([$tid]);
            foreach ($stmt as $row) {
                if ((int)$row['yellows'] >= $th) {
                    $exists = $pdo->prepare("SELECT COUNT(*) c FROM player_suspensions WHERE player_id=? AND tournament_id=? AND reason='accum_yellows' AND active=1");
                    $exists->execute([(int)$row['player_id'], $tid]);
                    if ((int)$exists->fetch()['c'] == 0) {
                        $next = $pdo->prepare("SELECT id FROM matches
                                               WHERE tournament_id=? AND (home_team_id=? OR away_team_id=?)
                                                 AND (home_goals IS NULL OR away_goals IS NULL)
                                                 AND id > ?
                                               ORDER BY id ASC LIMIT 1");
                        $next->execute([$tid, (int)$row['team_id'], (int)$row['team_id'], $match_id]);
                        $next_row = $next->fetch();
                        $next_id = $next_row ? (int)$next_row['id'] : null;
                        $insS = $pdo->prepare("INSERT INTO player_suspensions(player_id, team_id, tournament_id, origin_match_id, match_id, matches_remaining, reason, active) VALUES (?,?,?,?,?,?,?,1)");
                        $insS->execute([(int)$row['player_id'], (int)$row['team_id'], $tid, $match_id, $next_id, max(1,(int)$rules['yellow_threshold_matches']), 'accum_yellows']);
                        if ((int)$rules['yellow_reset_on_suspension'] === 1) {
                            $pdo->prepare("UPDATE player_card_accum SET yellows=0 WHERE id=?")->execute([(int)$row['id']]);
                        }
                    }
                }
            }
        }
    }
}
