<?php
namespace App\Models;

class Standings {
    public static function computeByTournament(int $tournament_id): array {
        $pdo = Database::conn();
        // init rows for teams in tournament
        $tstmt = $pdo->prepare("SELECT te.id, te.name, te.short_name FROM tournament_teams tt JOIN teams te ON te.id=tt.team_id WHERE tt.tournament_id=?");
        $tstmt->execute([$tournament_id]);
        $teams = $tstmt->fetchAll();
        $table = [];
        foreach ($teams as $t) {
            $table[$t['id']] = [
                'team_id'=>$t['id'],'name'=>$t['name'],'short'=>$t['short_name'],
                'pj'=>0,'g'=>0,'e'=>0,'p'=>0,'gf'=>0,'gc'=>0,'dg'=>0,'pts'=>0
            ];
        }
        $stmt = $pdo->prepare("SELECT * FROM matches WHERE stage='league' AND tournament_id=? AND home_goals IS NOT NULL AND away_goals IS NOT NULL");
        $stmt->execute([$tournament_id]);
        foreach ($stmt as $m) {
            $h=$m['home_team_id']; $a=$m['away_team_id']; $hg=(int)$m['home_goals']; $ag=(int)$m['away_goals'];
            if (!isset($table[$h])||!isset($table[$a])) continue;
            $table[$h]['pj']++; $table[$a]['pj']++;
            $table[$h]['gf'] += $hg; $table[$h]['gc'] += $ag;
            $table[$a]['gf'] += $ag; $table[$a]['gc'] += $hg;
            if ($hg>$ag){$table[$h]['g']++;$table[$a]['p']++;$table[$h]['pts']+=3;}
            elseif($hg<$ag){$table[$a]['g']++;$table[$h]['p']++;$table[$a]['pts']+=3;}
            else{$table[$h]['e']++;$table[$a]['e']++;$table[$h]['pts']++;$table[$a]['pts']++;}
        }
        foreach ($table as &$row){$row['dg']=$row['gf']-$row['gc'];}
        usort($table,function($x,$y){
            if ($x['pts']!==$y['pts']) return $y['pts']<=>$x['pts'];
            if ($x['dg']!==$y['dg']) return $y['dg']<=>$x['dg'];
            if ($x['gf']!==$y['gf']) return $y['gf']<=>$x['gf'];
            return strcasecmp($x['name'],$y['name']);
        });
        return $table;
    }

    public static function compute(): array {
        $pdo = Database::conn();
        // Get teams
        $teams = $pdo->query("SELECT id, name, short_name FROM teams")->fetchAll();
        $table = [];
        foreach ($teams as $t) {
            $table[$t['id']] = [
                'team_id' => $t['id'],
                'name' => $t['name'],
                'short' => $t['short_name'],
                'pj' => 0, 'g' => 0, 'e' => 0, 'p' => 0,
                'gf' => 0, 'gc' => 0, 'dg' => 0, 'pts' => 0
            ];
        }
        // Only league matches
        $stmt = $pdo->query("SELECT * FROM matches WHERE stage = 'league' AND home_goals IS NOT NULL AND away_goals IS NOT NULL");
        foreach ($stmt as $m) {
            $h = $m['home_team_id']; $a = $m['away_team_id'];
            $hg = (int)$m['home_goals']; $ag = (int)$m['away_goals'];
            if (!isset($table[$h]) || !isset($table[$a])) continue;
            // home
            $table[$h]['pj']++; $table[$a]['pj']++;
            $table[$h]['gf'] += $hg; $table[$h]['gc'] += $ag;
            $table[$a]['gf'] += $ag; $table[$a]['gc'] += $hg;
            if ($hg > $ag) { $table[$h]['g']++; $table[$a]['p']++; $table[$h]['pts'] += 3; }
            elseif ($hg < $ag) { $table[$a]['g']++; $table[$h]['p']++; $table[$a]['pts'] += 3; }
            else { $table[$h]['e']++; $table[$a]['e']++; $table[$h]['pts']++; $table[$a]['pts']++; }
        }
        // DG
        foreach ($table as &$row) { $row['dg'] = $row['gf'] - $row['gc']; }
        // Sort by pts, DG, GF
        usort($table, function($x,$y){
            if ($x['pts'] !== $y['pts']) return $y['pts'] <=> $x['pts'];
            if ($x['dg'] !== $y['dg']) return $y['dg'] <=> $x['dg'];
            if ($x['gf'] !== $y['gf']) return $y['gf'] <=> $x['gf'];
            return strcasecmp($x['name'], $y['name']);
        });
        return $table;
    }
}
