<?php
namespace App\Models;

class SanctionRule {
    public static function getByTournament($tid) {
        $pdo = Database::conn();
        $stmt = $pdo->prepare("SELECT * FROM sanction_rules WHERE tournament_id=?");
        $stmt->execute([$tid]);
        $r = $stmt->fetch();
        if (!$r) {
            return [
                'tournament_id'=>$tid,
                'red_min_matches'=>1,
                'double_yellow_matches'=>1,
                'yellow_threshold'=>5,
                'yellow_threshold_matches'=>1,
                'yellow_reset_on_suspension'=>1,
                'carry_over_to_playoffs'=>1
            ];
        }
        return $r;
    }
    public static function upsert($tid, $data) {
        $pdo = Database::conn();
        $stmt = $pdo->prepare("SELECT id FROM sanction_rules WHERE tournament_id=?");
        $stmt->execute([$tid]);
        $has = $stmt->fetch();
        if ($has) {
            $stmt = $pdo->prepare("UPDATE sanction_rules SET red_min_matches=?, double_yellow_matches=?, yellow_threshold=?, yellow_threshold_matches=?, yellow_reset_on_suspension=?, carry_over_to_playoffs=? WHERE tournament_id=?");
            $stmt->execute([$data['red_min_matches'],$data['double_yellow_matches'],$data['yellow_threshold'],$data['yellow_threshold_matches'],$data['yellow_reset_on_suspension'],$data['carry_over_to_playoffs'],$tid]);
        } else {
            $stmt = $pdo->prepare("INSERT INTO sanction_rules(tournament_id, red_min_matches, double_yellow_matches, yellow_threshold, yellow_threshold_matches, yellow_reset_on_suspension, carry_over_to_playoffs) VALUES (?,?,?,?,?,?,?)");
            $stmt->execute([$tid,$data['red_min_matches'],$data['double_yellow_matches'],$data['yellow_threshold'],$data['yellow_threshold_matches'],$data['yellow_reset_on_suspension'],$data['carry_over_to_playoffs']]);
        }
    }
}
