<?php
namespace App\Models;

class Player {
    public static function byTeam($team_id) {
        $pdo = Database::conn();
        $stmt = $pdo->prepare("SELECT * FROM players WHERE team_id=? ORDER BY number IS NULL, number, name");
        $stmt->execute([$team_id]);
        return $stmt->fetchAll();
    }
    public static function create($team_id, $name, $number=null, $position=null) {
        $pdo = Database::conn();
        $stmt = $pdo->prepare("INSERT INTO players(team_id, name, number, position) VALUES (?,?,?,?)");
        $stmt->execute([$team_id, $name, $number, $position]);
    }
    public static function delete($id) {
        $pdo = Database::conn();
        $pdo->prepare("DELETE FROM players WHERE id=?")->execute([$id]);
    }
    public static function find($id) {
        $pdo = Database::conn();
        $stmt = $pdo->prepare("SELECT * FROM players WHERE id=?");
        $stmt->execute([$id]);
        return $stmt->fetch();
    }
}
