<?php
namespace App\Models;

class MatchEvent {
    public static function list($match_id) {
        $pdo = Database::conn();
        $sql = "SELECT me.*, p.name AS player_name, r.name AS related_name, t.name AS team_name
                FROM match_events me
                LEFT JOIN players p ON p.id = me.player_id
                LEFT JOIN players r ON r.id = me.related_player_id
                JOIN teams t ON t.id = me.team_id
                WHERE me.match_id=?
                ORDER BY minute, id";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$match_id]);
        return $stmt->fetchAll();
    }
    public static function add($match_id, $team_id, $player_id, $minute, $type, $related_player_id = null, $notes=null) {
        $pdo = Database::conn();
        $stmt = $pdo->prepare("INSERT INTO match_events(match_id, team_id, player_id, minute, type, related_player_id, notes) VALUES (?,?,?,?,?,?,?)");
        $stmt->execute([$match_id, $team_id, $player_id ?: null, $minute, $type, $related_player_id ?: null, $notes]);
        self::recalcScore($match_id);
        \App\Models\Suspension::evaluateMatch($match_id);
    }
    public static function delete($id) {
        $pdo = Database::conn();
        $stmt = $pdo->prepare("SELECT match_id FROM match_events WHERE id=?");
        $stmt->execute([$id]);
        $row = $stmt->fetch();
        $match_id = $row ? (int)$row['match_id'] : 0;
        $pdo->prepare("DELETE FROM match_events WHERE id=?")->execute([$id]);
        if ($match_id) self::recalcScore($match_id);
        \App\Models\Suspension::evaluateMatch($match_id);
    }
    public static function recalcScore($match_id) {
        $pdo = Database::conn();
        $sql = "SELECT m.id, m.home_team_id, m.away_team_id FROM matches m WHERE m.id=?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$match_id]);
        $m = $stmt->fetch();
        if (!$m) return;
        $home = 0; $away = 0;
        $ev = $pdo->prepare("SELECT team_id, type FROM match_events WHERE match_id=?");
        $ev->execute([$match_id]);
        foreach ($ev as $e) {
            $delta = 0;
            if (in_array($e['type'], ['goal','penalty_goal'])) $delta = 1;
            if ($e['type'] === 'own_goal') $delta = -1; // own goal adds to opponent
            if ($e['team_id'] == $m['home_team_id']) {
                if ($delta == 1) $home++;
                if ($delta == -1) $away++;
            } else if ($e['team_id'] == $m['away_team_id']) {
                if ($delta == 1) $away++;
                if ($delta == -1) $home++;
            }
        }
        $pdo->prepare("UPDATE matches SET home_goals=?, away_goals=? WHERE id=?")->execute([$home, $away, $match_id]);
    }
}
