<?php
namespace App\Models;

class Lineup {
    private static function suspended($player_id, $match_id){ return \App\Models\Suspension::isPlayerSuspendedForMatch($player_id,$match_id); }
    public static function list($match_id, $team_id) {
        $pdo = Database::conn();
        $sql = "SELECT ml.*, p.name, p.number, p.position
                FROM match_lineups ml
                JOIN players p ON p.id = ml.player_id
                WHERE ml.match_id=? AND ml.team_id=?
                ORDER BY ml.is_starter DESC, p.number IS NULL, p.number, p.name";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$match_id, $team_id]);
        return $stmt->fetchAll();
    }
    public static function add($match_id, $team_id, $player_id, $is_starter) {
        $pdo = Database::conn();
                if (self::suspended($player_id, $match_id)) { throw new \Exception('El jugador está suspendido para este partido'); }
        $stmt = $pdo->prepare("INSERT IGNORE INTO match_lineups(match_id, team_id, player_id, is_starter) VALUES (?,?,?,?)");
        $stmt->execute([$match_id, $team_id, $player_id, $is_starter?1:0]);
    }
    public static function setMinutes($id, $min_in, $min_out) {
        $pdo = Database::conn();
        $stmt = $pdo->prepare("UPDATE match_lineups SET minute_in=?, minute_out=? WHERE id=?");
        $stmt->execute([$min_in, $min_out, $id]);
    }
    public static function remove($match_id, $player_id) {
        $pdo = Database::conn();
        $stmt = $pdo->prepare("DELETE FROM match_lineups WHERE match_id=? AND player_id=?");
        $stmt->execute([$match_id, $player_id]);
    }
}
