<?php
namespace App\Models;

class Fixture {
    // Simple round-robin generator (Berger tables)
    public static function generateRoundRobin(array $teamIds, $tournament_id=null) {
        $pdo = Database::conn();
        $ids = array_values(array_unique(array_map('intval', $teamIds)));
        $n = count($ids);
        if ($n % 2 === 1) { $ids[] = 0; $n++; } // 0 = bye
        $rounds = $n - 1;
        $half = $n // 2
;        $left = array_slice($ids, 0, $half);
        $right = array_slice($ids, $half);
        for ($r=1; $r <= $rounds; $r++) {
            for ($i=0; $i < $half; $i++) {
                $home = $left[$i];
                $away = $right[$half - $i - 1];
                if ($home !== 0 && $away !== 0) {
                    MatchModel::create($home, $away, $r, $tournament_id); // stage defaults to 'league'
                }
            }
            // rotate
            $fixed = array_shift($left);
            $moved = array_shift($right);
            array_unshift($left, $moved);
            array_push($right, array_pop($left));
            array_unshift($left, $fixed);
        }
    }
}
