<?php
namespace App\Models;

use PDO;
use PDOException;

class Database {
    private static $pdo = null;

    public static function conn(): PDO {
        if (self::$pdo === null) {
            $config = require __DIR__ . '/../../config/config.php';
            $dsn = "mysql:host={$config['db']['host']};dbname={$config['db']['name']};charset={$config['db']['charset']}";
            try {
                self::$pdo = new PDO($dsn, $config['db']['user'], $config['db']['pass'], [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                ]);
            } catch (PDOException $e) {
                die("DB connection error: " . $e->getMessage());
            }
        }
        return self::$pdo;
    }
}
