<?php
namespace App\Core;

class Router {
    private $routes = [];

    public function get($path, $handler) { $this->add('GET', $path, $handler); }
    public function post($path, $handler) { $this->add('POST', $path, $handler); }

    private function add($method, $path, $handler) {
        $this->routes[] = compact('method','path','handler');
    }

    public function dispatch() {
        $method = $_SERVER['REQUEST_METHOD'];
        $r = $_GET['r'] ?? 'home';
        foreach ($this->routes as $route) {
            if ($route['method'] === $method && $route['path'] === $r) {
                return call_user_func($route['handler']);
            }
        }
        http_response_code(404);
        echo "404 - Ruta no encontrada";
    }
}
