<?php
namespace App\Controllers;

use App\Models\Tournament;
use App\Models\Team;
use App\Models\TournamentTeam;

class TournamentSetupController {
    public static function config() {
        require_login();
        $tid = intval($_GET['tid'] ?? 0);
        $tournaments = Tournament::allWithSettings();
        if ($tid===0 && !empty($tournaments)) $tid = $tournaments[0]['id'];
        $t = $tid ? Tournament::find($tid) : null;
        $assigned = $tid ? TournamentTeam::listTeams($tid) : [];
        $allTeams = Team::all();
        view('tournaments/setup', compact('tournaments','tid','t','assigned','allTeams'));
    }
    public static function saveSettings() {
        require_login();
        $tid = intval($_POST['tournament_id'] ?? 0);
        $target = $_POST['knockout_target'] ?? 'QF';
        $direct = intval($_POST['direct_qualifiers'] ?? 4);
        $playin = intval($_POST['playin_slots'] ?? 0);
        $twolegs = isset($_POST['two_legs']) ? 1 : 0;
        Tournament::updateSettings($tid, $target, $direct, $playin, $twolegs);
        redirect('tournament_setup&tid='.$tid);
    }
    public static function addTeam() {
        require_login();
        $tid = intval($_POST['tournament_id'] ?? 0);
        $team_id = intval($_POST['team_id'] ?? 0);
        if ($tid && $team_id) TournamentTeam::add($tid, $team_id);
        redirect('tournament_setup&tid='.$tid);
    }
    public static function removeTeam() {
        require_login();
        $tid = intval($_POST['tournament_id'] ?? 0);
        $team_id = intval($_POST['team_id'] ?? 0);
        if ($tid && $team_id) TournamentTeam::remove($tid, $team_id);
        redirect('tournament_setup&tid='.$tid);
    }
}
