<?php
namespace App\Controllers;

use App\Models\Standings;
use App\Models\Playoff;
use App\Models\MatchModel;
use App\Models\Tournament;

class PlayoffController {
    public static function index() {
        require_login();
        $tid = intval($_GET['tid'] ?? 0);
        $semis = $tid ? Playoff::getByStage($tid, 'semi') : [];
        $final = $tid ? Playoff::getFinal($tid) : null;
        $r16 = $tid ? Playoff::getByStage($tid, 'R16') : [];
        $qf = $tid ? Playoff::getByStage($tid, 'QF') : [];
        $playin = $tid ? Playoff::getByStage($tid, 'playin') : [];
        $tournament = $tid ? Tournament::find($tid) : null;
        view('playoffs/index', compact('semis','final','r16','qf','playin','tournament','tid'));
    }

    public static function generate() {
        require_login();
        $tid = intval($_POST['tournament_id'] ?? 0);
        $t = Tournament::find($tid);
        if (!$t) { redirect('playoffs'); }
        $rules = [
            'knockout_target' => $t['knockout_target'],
            'direct_qualifiers' => (int)$t['direct_qualifiers'],
            'playin_slots' => (int)$t['playin_slots'],
        ];
        $table = Standings::computeByTournament($tid);
        if (count($table) < 2) {
            $error = 'Necesitas más equipos/resultados para generar llaves.';
            $semis = Playoff::getByStage($tid, 'semi');
            $final = Playoff::getFinal($tid);
            $r16 = Playoff::getByStage($tid, 'R16');
            $qf = Playoff::getByStage($tid, 'QF');
            $playin = Playoff::getByStage($tid, 'playin');
            $tournament = $t;
            view('playoffs/index', compact('semis','final','r16','qf','playin','tournament','tid','error'));
            return;
        }
        Playoff::generateAccordingToRules($table, $rules, $tid);
        redirect('playoffs&tid='.$tid);
    }

    public static function saveResult() {
        require_login();
        $match_id = (int)($_POST['match_id'] ?? 0);
        $home_goals = (int)($_POST['home_goals'] ?? 0);
        $away_goals = (int)($_POST['away_goals'] ?? 0);
        MatchModel::setResult($match_id, $home_goals, $away_goals);
        $tid = intval($_POST['tournament_id'] ?? 0);
        if ($tid) {
            \App\Models\Playoff::refreshProgression($tid);
        }
        redirect('playoffs&tid='.$tid);
    }
}
