<?php
namespace App\Controllers;

use App\Models\Team;
use App\Models\Player;

class PlayerController {
    public static function index() {
        require_login();
        $team_id = intval($_GET['team_id'] ?? 0);
        $teams = Team::all();
        $players = $team_id ? Player::byTeam($team_id) : [];
        view('players/index', compact('teams','players','team_id'));
    }
    public static function store() {
        require_login();
        $team_id = intval($_POST['team_id'] ?? 0);
        $name = trim($_POST['name'] ?? '');
        $number = $_POST['number'] !== '' ? intval($_POST['number']) : null;
        $position = $_POST['position'] ?? null;
        if ($team_id && $name) Player::create($team_id, $name, $number, $position);
        redirect('players&team_id='.$team_id);
    }
    public static function delete() {
        require_login();
        $id = intval($_POST['id'] ?? 0);
        $team_id = intval($_POST['team_id'] ?? 0);
        if ($id) Player::delete($id);
        redirect('players&team_id='.$team_id);
    }
}
