<?php
namespace App\Controllers;

use App\Models\MatchModel;
use App\Models\Team;
use App\Models\Player;
use App\Models\Lineup;
use App\Models\MatchEvent;

class MatchDetailController {
    public static function show() {
        require_login();
        $match_id = intval($_GET['id'] ?? 0);
        $pdo = \App\Models\Database::conn();
        $sql = "SELECT m.*, h.name AS home_name, a.name AS away_name
                FROM matches m
                JOIN teams h ON h.id=m.home_team_id
                JOIN teams a ON a.id=m.away_team_id
                WHERE m.id=?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$match_id]);
        $match = $stmt->fetch();

        if (!$match) { echo "Partido no encontrado"; return; }

        $home_players = Player::byTeam($match['home_team_id']);
        $away_players = Player::byTeam($match['away_team_id']);
        $home_lineup = Lineup::list($match_id, $match['home_team_id']);
        $away_lineup = Lineup::list($match_id, $match['away_team_id']);
        $events = MatchEvent::list($match_id);

        view('fixtures/detail', compact('match','home_players','away_players','home_lineup','away_lineup','events'));
    }

    public static function addLineup() {
        require_login();
        $match_id = intval($_POST['match_id'] ?? 0);
        $team_id = intval($_POST['team_id'] ?? 0);
        $player_id = intval($_POST['player_id'] ?? 0);
        $is_starter = isset($_POST['is_starter']);
        if ($match_id && $team_id && $player_id) {
            try { Lineup::add($match_id, $team_id, $player_id, $is_starter); }
        catch(\Exception $e){ $_SESSION['flash_error'] = $e->getMessage(); }
        }
        redirect('match_detail&id='.$_POST['match_id']);
    }

    public static function removeLineup() {
        require_login();
        $match_id = intval($_POST['match_id'] ?? 0);
        $player_id = intval($_POST['player_id'] ?? 0);
        if ($match_id && $player_id) Lineup::remove($match_id, $player_id);
        redirect('match_detail&id='.$match_id);
    }

    public static function addEvent() {
        require_login();
        $match_id = intval($_POST['match_id'] ?? 0);
        $team_id = intval($_POST['team_id'] ?? 0);
        $player_id = $_POST['player_id'] !== '' ? intval($_POST['player_id']) : null;
        $minute = intval($_POST['minute'] ?? 0);
        $type = $_POST['type'] ?? 'goal';
        $related = $_POST['related_player_id'] !== '' ? intval($_POST['related_player_id']) : null;
        $notes = $_POST['notes'] ?? null;
        if ($match_id && $team_id && $minute>=0) {
            \App\Models\MatchEvent::add($match_id, $team_id, $player_id, $minute, $type, $related, $notes);
        }
        redirect('match_detail&id='.$match_id);
    }

    public static function deleteEvent() {
        require_login();
        $id = intval($_POST['id'] ?? 0);
        $match_id = intval($_POST['match_id'] ?? 0);
        if ($id) \App\Models\MatchEvent::delete($id);
        redirect('match_detail&id='.$match_id);
    }
}
