# Futbol Torneos PHP v1

Sistema mínimo para administrar torneos de fútbol profesional (base).

## Requisitos
- PHP 8.1+ con PDO MySQL
- MySQL 8.x
- Servidor web (Apache/Nginx). En Apache, puede usarse `public/index.php?r=...` sin .htaccess

## Instalación
1. Cree la base de datos `futbol_torneos` en MySQL.
2. Importe `db/schema.sql`.
3. Copie `.env.example` a `.env` y ajuste credenciales.
4. Publique el directorio `public/` en su hosting (o configure DocumentRoot allí).
5. Ingrese con: **admin@example.com / admin123**

## Rutas
- `index.php?r=login`
- `index.php?r=dashboard`
- `index.php?r=tournaments` (CRUD básico crear)
- `index.php?r=teams` (CRUD básico crear)
- `index.php?r=fixtures` (generar todos contra todos y cargar resultados)

## Próximos pasos (sugerencias)
- Módulo de jugadores y plantillas por equipo
- Árbitros, canchas y programación por fecha/hora
- Tabla de posiciones con desempates (Pts, DG, GF, GC, PJ, PE, PP, head-to-head)
- Playoffs/brackets
- Roles y permisos avanzados
- API JSON y endpoints móviles
- Reportes PDF/Excel

## Novedades v2
- **Tabla de posiciones** en tiempo real (liga) con Pts, PJ, G, E, P, GF, GC, DG.
- **Playoffs**: genera semifinales (1 vs 4, 2 vs 3) y final; guarda resultados y actualiza final automáticamente.
- Ampliación de `matches` con `stage` y `leg` (monopartido en v2).

### Actualización desde v1
Si vienes de v1, ejecuta en MySQL:
```sql
ALTER TABLE matches
  ADD COLUMN stage ENUM('league','semi','final') NOT NULL DEFAULT 'league',
  ADD COLUMN leg TINYINT NOT NULL DEFAULT 1;
```
(No hace falta si instalas v2 desde cero.)

### Rutas nuevas
- `?r=standings` (tabla de posiciones)
- `?r=playoffs` (gestión de semifinales y final)
- `POST ?r=playoffs_generate` (generar desde top 4)
- `POST ?r=playoffs_save` (guardar marcador de un partido de playoffs)

## Novedades v3
- **Torneos flexibles**: define por torneo si el objetivo de llaves es **Octavos (R16)** o **Cuartos (QF)**.
- **Clasificación configurable**: por torneo eliges cuántos van **directo** a R16/QF y cuántos pasan a **Play-in** para completar el cuadro.
- **Asignación de equipos por torneo** y generación de fixture/tabla con scope de torneo.
- **Progresión automática**: play-in → R16/QF → Semis → Final.

### Actualización desde v2
Ejecuta en MySQL (si ya tenías datos):
```sql
ALTER TABLE tournaments
  ADD COLUMN knockout_target ENUM('R16','QF') NOT NULL DEFAULT 'QF',
  ADD COLUMN direct_qualifiers INT NOT NULL DEFAULT 4,
  ADD COLUMN playin_slots INT NOT NULL DEFAULT 0,
  ADD COLUMN two_legs TINYINT NOT NULL DEFAULT 0;

ALTER TABLE matches
  ADD COLUMN tournament_id INT NULL,
  ADD CONSTRAINT fk_match_tournament FOREIGN KEY (tournament_id) REFERENCES tournaments(id) ON DELETE CASCADE;

CREATE TABLE IF NOT EXISTS tournament_teams (
  id INT AUTO_INCREMENT PRIMARY KEY,
  tournament_id INT NOT NULL,
  team_id INT NOT NULL,
  UNIQUE KEY uniq_tt (tournament_id, team_id),
  CONSTRAINT fk_tt_t FOREIGN KEY (tournament_id) REFERENCES tournaments(id) ON DELETE CASCADE,
  CONSTRAINT fk_tt_team FOREIGN KEY (team_id) REFERENCES teams(id) ON DELETE CASCADE
);
```

### Flujo recomendado
1. **Crear torneo** y configurar reglas en `?r=tournament_setup` (objetivo R16/QF, directos, play-in).
2. **Asignar equipos** al torneo.
3. Generar **fixture de liga** en `?r=fixtures&tid={ID}` (usará los equipos del torneo).
4. Cargar resultados → ver **tabla** en `?r=standings&tid={ID}`.
5. Generar **llaves** en `?r=playoffs&tid={ID}` según reglas seleccionadas.
6. Cargar resultados y dejar que el sistema **avance** automáticamente.

> v4 (siguiente): ida/vuelta, reglas de desempate configurables, DataTables y reportes.

## Novedades v4
- **Jugadores por equipo** (número, nombre, posición).
- **Acta de partido** con:
  - **Alineaciones** (titulares/suplentes) por equipo.
  - **Eventos**: goles, gol de penal, autogol, amarilla, roja, entra/sale (cambios).
  - **Recalculo automático de marcador** desde los eventos.
- Rutas: `?r=players`, `?r=match_detail&id={match_id}` (en Fixture aparece botón **Acta**).

> Próximo: suspensiones automáticas por rojas/doble amarilla, asistencias explícitas, reportes PDF del acta.

## Novedades v5
- **Suspensiones automáticas** por **roja** o **doble amarilla** en un mismo partido.
- Se asigna automáticamente al **siguiente partido del mismo torneo** para ese equipo.
- Los jugadores suspendidos **no pueden** agregarse a la alineación del partido sancionado.
- Al **cerrar** (guardar resultado de) ese partido, la suspensión se marca como **cumplida**.
- En el Acta del partido, se listan los **suspendidos** por equipo.

> Nota: Por simplicidad v5 aplica 1 partido de suspensión. Si quieres reglas avanzadas (ej. más partidos por roja directa, acumulación de amarillas entre partidos), lo implementamos en v6.
